/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityItem;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.IProjectile;
import noppes.npcs.api.event.BlockEvent;
import noppes.npcs.api.event.CustomContainerEvent;
import noppes.npcs.api.event.CustomGuiEvent;
import noppes.npcs.api.event.DialogEvent;
import noppes.npcs.api.event.ForgeEvent;
import noppes.npcs.api.event.HandlerEvent;
import noppes.npcs.api.event.ItemEvent;
import noppes.npcs.api.event.NpcEvent;
import noppes.npcs.api.event.PackageReceived;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.event.ProjectileEvent;
import noppes.npcs.api.event.QuestEvent;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.api.event.WorldEvent;
import noppes.npcs.api.event.potion.AffectEntity;
import noppes.npcs.api.event.potion.EndEffect;
import noppes.npcs.api.event.potion.IsReadyEvent;
import noppes.npcs.api.event.potion.PerformEffect;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.handler.IFactionHandler;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.handler.data.IKeySetting;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.ContainerCustomChestWrapper;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.controllers.CustomGuiController;
import noppes.npcs.controllers.IScriptBlockHandler;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.BaseScriptData;
import noppes.npcs.controllers.data.ClientScriptData;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.ForgeScriptData;
import noppes.npcs.controllers.data.NpcScriptData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.controllers.data.PotionScriptData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.entity.data.DataScript;
import org.apache.commons.lang3.StringUtils;

public class EventHooks {
    public static void onClientInit(ClientScriptData handler) {
        if (!handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.INIT, (Event)new PlayerEvent.InitEvent((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)CustomNpcs.proxy.getPlayer())));
    }

    public static void onCustomChestClicked(CustomContainerEvent.SlotClickedEvent event) {
        ContainerCustomChestWrapper container = (ContainerCustomChestWrapper)event.container;
        if (!container.script.isValid()) {
            return;
        }
        EventHooks.onEvent(container.script, EnumScriptType.CUSTOM_CHEST_CLICKED, (Event)event);
    }

    public static void onCustomChestClosed(CustomContainerEvent.CloseEvent event) {
        ContainerCustomChestWrapper container = (ContainerCustomChestWrapper)event.container;
        if (!container.script.isValid()) {
            return;
        }
        EventHooks.onEvent(container.script, EnumScriptType.CUSTOM_CHEST_CLOSED, (Event)event);
    }

    public static void onCustomGuiButton(PlayerWrapper<?> player, ICustomGui gui, int buttonId) {
        CustomGuiController.onButton(new CustomGuiEvent.ButtonEvent(player, gui, buttonId));
    }

    public static void onCustomGuiClose(PlayerWrapper<?> player, ICustomGui gui) {
        CustomGuiController.onClose(new CustomGuiEvent.CloseEvent(player, gui));
    }

    public static void onCustomGuiScrollClick(PlayerWrapper<?> player, ICustomGui gui, int scrollId, int scrollIndex, String[] selection, boolean doubleClick) {
        CustomGuiController.onScrollClick(new CustomGuiEvent.ScrollEvent(player, gui, scrollId, scrollIndex, selection, doubleClick));
    }

    public static void onCustomGuiSlot(PlayerWrapper<?> player, ICustomGui gui, int slotId, IItemStack stack, IItemStack heldItem) {
        CustomGuiController.onSlotChange(new CustomGuiEvent.SlotEvent(player, gui, slotId, stack, heldItem));
    }

    public static boolean onCustomGuiSlotClicked(PlayerWrapper<?> player, ICustomGui gui, int slotId, int dragType, String clickType, IItemStack heldItem, Slot slot) {
        return CustomGuiController.onSlotClick(new CustomGuiEvent.SlotClickEvent(player, gui, slotId, player.getOpenContainer().getSlot(slotId), dragType, clickType, heldItem, slot));
    }

    public static void onCustomPotionAffectEntity(AffectEntity event) {
        PotionScriptData data = ScriptController.Instance.potionScripts;
        if (!data.isEnabled() || data.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)data, EnumScriptType.POTION_AFFECT, (Event)event);
    }

    public static void onCustomPotionEndEffect(EndEffect event) {
        PotionScriptData data = ScriptController.Instance.potionScripts;
        if (!data.isEnabled() || data.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)data, EnumScriptType.POTION_END, (Event)event);
    }

    public static void onCustomPotionIsReady(IsReadyEvent event) {
        PotionScriptData data = ScriptController.Instance.potionScripts;
        if (!data.isEnabled() || data.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)data, EnumScriptType.POTION_IS_READY, (Event)event);
    }

    public static void onCustomPotionPerformEffect(PerformEffect event) {
        PotionScriptData data = ScriptController.Instance.potionScripts;
        if (!data.isEnabled() || data.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)data, EnumScriptType.POTION_PERFORM, (Event)event);
    }

    public static boolean onEvent(IScriptHandler handler, EnumScriptType enumFunction, Event event) {
        if (handler instanceof DataScript && ((DataScript)handler).npc.ais.aiDisabled) {
            return false;
        }
        if (handler instanceof PlayerScriptData && handler.getEnabled() != ScriptController.Instance.playerScripts.getEnabled()) {
            handler.setEnabled(ScriptController.Instance.playerScripts.getEnabled());
        }
        if (event == null || enumFunction == null || enumFunction.function.isEmpty()) {
            return false;
        }
        if (handler instanceof NpcScriptData && ScriptController.Instance.npcsScripts.getEnabled()) {
            ScriptController.Instance.npcsScripts.runScript(enumFunction.function, event);
        }
        if (handler == null || !handler.getEnabled()) {
            return false;
        }
        handler.runScript(enumFunction.function, event);
        return WrapperNpcAPI.EVENT_BUS.post(event) && event.isCanceled();
    }

    public static boolean onEvent(IScriptHandler handler, String enumFunction, Event event) {
        if (handler instanceof DataScript && ((DataScript)handler).npc.ais.aiDisabled) {
            return false;
        }
        if (event == null || enumFunction == null || enumFunction.isEmpty()) {
            return false;
        }
        if (handler instanceof NpcScriptData && ScriptController.Instance.npcsScripts.getEnabled()) {
            ScriptController.Instance.npcsScripts.runScript(enumFunction, event);
        }
        if (handler == null || !handler.getEnabled()) {
            return false;
        }
        handler.runScript(enumFunction, event);
        return WrapperNpcAPI.EVENT_BUS.post(event) && event.isCanceled();
    }

    public static boolean onEvent(ScriptContainer script, EnumScriptType enumFunction, Event event) {
        if (script == null || event == null || enumFunction == null) {
            return false;
        }
        script.run(enumFunction.function, event);
        return WrapperNpcAPI.EVENT_BUS.post(event) && event.isCanceled();
    }

    public static void onForgeEvent(Event event) {
        String eventName;
        if (event == null) {
            return;
        }
        ForgeScriptData handler = ScriptController.Instance.forgeScripts;
        if (!handler.isClient() && handler.isEnabled()) {
            if (!ScriptController.forgeEventNames.containsKey(event.getClass())) {
                eventName = event.getClass().getName();
                int i = eventName.lastIndexOf(".");
                eventName = StringUtils.uncapitalize((String)eventName.substring(i + 1).replace("$", ""));
                ScriptController.forgeEventNames.put(event.getClass(), eventName);
                LogWriter.info("Found new Forge Event \"" + eventName + "\" to event: " + event.getClass().getName());
            } else {
                eventName = ScriptController.forgeEventNames.get(event.getClass());
            }
            try {
                handler.runScript(eventName, event);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        if (handler.isClient()) {
            ClientScriptData handlerClient = ScriptController.Instance.clientScripts;
            if (!handlerClient.isClient() || !handlerClient.isEnabled()) {
                return;
            }
            if (!ScriptController.forgeClientEventNames.containsKey(event.getClass())) {
                eventName = event.getClass().getName();
                int i = eventName.lastIndexOf(".");
                eventName = StringUtils.uncapitalize((String)eventName.substring(i + 1).replace("$", ""));
                ScriptController.forgeClientEventNames.put(event.getClass(), eventName);
                LogWriter.info("Found new Forge Event \"" + eventName + "\" to event: " + event.getClass().getName());
            } else {
                eventName = ScriptController.forgeClientEventNames.get(event.getClass());
            }
            try {
                handlerClient.runScript(eventName, event);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
    }

    public static void onForgeInit(ForgeScriptData handler) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.INIT, (Event)new ForgeEvent.InitEvent());
    }

    public static void onNPCsInit(NpcScriptData handler) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.INIT, (Event)new NpcEvent.InitEvent(null));
    }

    public static void onGlobalFactionsLoaded(IFactionHandler handler) {
        HandlerEvent.FactionsLoadedEvent event = new HandlerEvent.FactionsLoadedEvent(handler);
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static boolean onNPCAttacksMelee(EntityNPCInterface npc, NpcEvent.MeleeAttackEvent event) {
        if (npc.script.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.ATTACK_MELEE, (Event)event);
    }

    public static void onNPCCollide(EntityNPCInterface npc, Entity entity) {
        if (npc.script.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.COLLIDE, (Event)new NpcEvent.CollideEvent(npc.wrappedNPC, entity));
    }

    public static void onNPCNeedBlockDamage(EntityNPCInterface npc, NpcEvent.NeedBlockDamage event) {
        if (npc.script.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.NEED_BLOCK_DAMAGED, (Event)event);
    }

    public static boolean onNPCDamaged(EntityNPCInterface npc, NpcEvent.DamagedEvent event) {
        if (npc.script.isClient()) {
            return false;
        }
        event.setCanceled(npc.isKilled());
        return EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.DAMAGED, (Event)event);
    }

    public static boolean onNPCDialog(EntityNPCInterface npc, EntityPlayer player, Dialog dialog) {
        if (npc.script.isClient()) {
            return false;
        }
        DialogEvent.OpenEvent event = new DialogEvent.OpenEvent(npc.wrappedNPC, player, dialog);
        if (npc.script != null && !(npc instanceof EntityDialogNpc)) {
            EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.DIALOG, (Event)event);
        }
        return EventHooks.onEvent((IScriptHandler)PlayerData.get((EntityPlayer)player).scriptData, EnumScriptType.DIALOG, (Event)event);
    }

    public static void onNPCDialogClose(EntityNPCInterface npc, EntityPlayerMP player, Dialog dialog) {
        if (npc.script.isClient()) {
            return;
        }
        DialogEvent.CloseEvent event = new DialogEvent.CloseEvent(npc.wrappedNPC, (EntityPlayer)player, dialog);
        if (npc.script != null && !(npc instanceof EntityDialogNpc)) {
            EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.DIALOG_CLOSE, (Event)event);
        }
        EventHooks.onEvent((IScriptHandler)PlayerData.get((EntityPlayer)player).scriptData, EnumScriptType.DIALOG_CLOSE, (Event)event);
    }

    public static boolean onNPCDialogOption(EntityNPCInterface npc, EntityPlayerMP player, Dialog dialog, DialogOption option) {
        if (npc.script.isClient()) {
            return false;
        }
        DialogEvent.OptionEvent event = new DialogEvent.OptionEvent(npc.wrappedNPC, (EntityPlayer)player, dialog, option);
        if (npc.script != null && !(npc instanceof EntityDialogNpc)) {
            EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.DIALOG_OPTION, (Event)event);
        }
        return EventHooks.onEvent((IScriptHandler)PlayerData.get((EntityPlayer)player).scriptData, EnumScriptType.DIALOG_OPTION, (Event)event);
    }

    public static void onNPCDied(EntityNPCInterface npc, NpcEvent.DiedEvent event) {
        if (npc.script.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.DIED, (Event)event);
    }

    public static void onNPCInit(EntityNPCInterface npc) {
        if (npc.script.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.INIT, (Event)new NpcEvent.InitEvent(npc.wrappedNPC));
    }

    public static boolean onNPCInteract(EntityNPCInterface npc, EntityPlayer player) {
        if (npc.script.isClient()) {
            return false;
        }
        NpcEvent.InteractEvent event = new NpcEvent.InteractEvent(npc.wrappedNPC, player);
        event.setCanceled(npc.isAttacking() || npc.isKilled() || npc.faction.isAggressiveToPlayer(player));
        return EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.INTERACT, (Event)event);
    }

    public static void onNPCKills(EntityNPCInterface npc, EntityLivingBase entityLiving) {
        if (npc.script.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.KILL, (Event)new NpcEvent.KilledEntityEvent(npc.wrappedNPC, entityLiving));
    }

    public static void onNPCRangedLaunched(EntityNPCInterface npc, NpcEvent.RangedLaunchedEvent event) {
        if (npc.script.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.RANGED_LAUNCHED, (Event)event);
    }

    public static boolean onNPCRole(EntityNPCInterface npc, RoleEvent event) {
        if (npc.script.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.ROLE, (Event)event);
    }

    public static void onNPCStopAnimation(EntityNPCInterface npc, int type, int variant) {
        if (npc.script.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.STOP_ANIMATION, (Event)new NpcEvent.StopAnimation(npc.wrappedNPC, type, variant));
    }

    public static boolean onNPCTarget(EntityNPCInterface npc, NpcEvent.TargetEvent event) {
        if (npc.script.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.TARGET, (Event)event);
    }

    public static boolean onNPCTargetLost(EntityNPCInterface npc, EntityLivingBase prevtarget) {
        if (npc.script.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.TARGET_LOST, (Event)new NpcEvent.TargetLostEvent(npc.wrappedNPC, prevtarget));
    }

    public static NpcEvent.CustomNpcTeleport onNpcTeleport(EntityNPCInterface npc, BlockPos to, BlockPos portal, int dimId) {
        NpcAPI api = NpcAPI.Instance();
        assert (api != null);
        NpcEvent.CustomNpcTeleport event = new NpcEvent.CustomNpcTeleport((ICustomNpc)api.getIEntity((Entity)npc), api.getIPos(portal.func_177958_n(), portal.func_177956_o(), portal.func_177952_p()), api.getIPos(to.func_177958_n(), to.func_177956_o(), to.func_177952_p()), dimId);
        if (npc == null) {
            return event;
        }
        DataScript handler = npc.script;
        if (!handler.getEnabled()) {
            return event;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.CUSTOM_TELEPORT, (Event)event);
        return event;
    }

    public static void onNPCTick(EntityNPCInterface npc) {
        if (!npc.script.isEnabled()) {
            return;
        }
        ScriptController.Instance.tryAdd(2, (Object)npc);
        if (npc.script.isClient()) {
            EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.TICK, (Event)new NpcEvent.UpdateEvent(npc.wrappedNPC));
            return;
        }
        EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.TICK, (Event)new NpcEvent.UpdateEvent(npc.wrappedNPC));
    }

    public static void onNPCTimer(EntityNPCInterface npc, int id) {
        EventHooks.onEvent((IScriptHandler)npc.script, EnumScriptType.TIMER, (Event)new NpcEvent.TimerEvent(npc.wrappedNPC, id));
    }

    public static void onPackageReceived(PackageReceived event, boolean isServerSide) {
        BaseScriptData handler = isServerSide ? ScriptController.Instance.forgeScripts : ScriptController.Instance.clientScripts;
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.PACKAGE_RECEIVED, (Event)event);
    }

    public static boolean onPlayerAttack(PlayerScriptData handler, PlayerEvent.AttackEvent event) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.ATTACK, (Event)event);
    }

    public static boolean onPlayerBreak(PlayerScriptData handler, PlayerEvent.BreakEvent event) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.BROKEN, (Event)event);
    }

    public static void onPlayerChat(PlayerScriptData handler, PlayerEvent.ChatEvent event) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.CHAT, (Event)event);
    }

    public static void onPlayerContainerClose(PlayerScriptData handler, Container container) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.CONTAINER_CLOSED, (Event)new PlayerEvent.ContainerClosed(handler.getPlayer(), Objects.requireNonNull(NpcAPI.Instance()).getIContainer(container)));
    }

    public static void onPlayerContainerOpen(PlayerScriptData handler, Container container) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.CONTAINER_OPEN, (Event)new PlayerEvent.ContainerOpen(handler.getPlayer(), Objects.requireNonNull(NpcAPI.Instance()).getIContainer(container)));
    }

    public static boolean onPlayerDamaged(PlayerScriptData handler, PlayerEvent.DamagedEvent event) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.DAMAGED, (Event)event);
    }

    public static boolean onPlayerDamagedEntity(PlayerScriptData handler, PlayerEvent.DamagedEntityEvent event) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.DAMAGED_ENTITY, (Event)event);
    }

    public static void onPlayerDeath(PlayerScriptData handler, DamageSource source, Entity entity) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.DIED, (Event)new PlayerEvent.DiedEvent(handler.getPlayer(), source, entity));
    }

    public static void onPlayerFactionChange(PlayerScriptData handler, PlayerEvent.FactionUpdateEvent event) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.FACTION_UPDATE, (Event)event);
    }

    public static boolean onPlayerFished(PlayerScriptData handler, NonNullList<ItemStack> drops, int rodDamage) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.ITEM_FISHED, (Event)new PlayerEvent.ItemFished(handler.getPlayer(), drops, rodDamage));
    }

    public static void onPlayerInit(PlayerScriptData handler) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.INIT, (Event)new PlayerEvent.InitEvent(handler.getPlayer()));
    }

    public static boolean onPlayerInteract(PlayerScriptData handler, PlayerEvent.InteractEvent event) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.INTERACT, (Event)event);
    }

    public static void onPlayerKeyActive(EntityPlayerMP player, int id) {
        if (player == null) {
            return;
        }
        IKeySetting kb = Objects.requireNonNull(NpcAPI.Instance()).getIKeyBinding().getKeySetting(id);
        if (kb == null) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)player).scriptData;
        if (!handler.getEnabled()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.KEY_ACTIVE, (Event)new PlayerEvent.KeyActive((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), kb));
    }

    public static void onPlayerKeyPressed(EntityPlayerMP player, int button, boolean isDown, boolean isCtrlPressed, boolean isShiftPressed, boolean isAltPressed, boolean isMetaPressed) {
        PlayerScriptData handler = PlayerData.get((EntityPlayer)player).scriptData;
        PlayerEvent.KeyPressedEvent event = new PlayerEvent.KeyPressedEvent(handler.getPlayer(), button, isCtrlPressed, isAltPressed, isShiftPressed, isMetaPressed);
        EventHooks.onEvent((IScriptHandler)handler, isDown ? EnumScriptType.KEY_DOWN : EnumScriptType.KEY_UP, (Event)event);
    }

    public static void onPlayerKills(PlayerScriptData handler, EntityLivingBase entityLiving) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.KILL, (Event)new PlayerEvent.KilledEntityEvent(handler.getPlayer(), entityLiving));
    }

    public static void onPlayerLevelUp(PlayerScriptData handler, int change) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.LEVEL_UP, (Event)new PlayerEvent.LevelUpEvent(handler.getPlayer(), change));
    }

    public static void onPlayerLogin(PlayerScriptData handler) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.LOGIN, (Event)new PlayerEvent.LoginEvent(handler.getPlayer()));
    }

    public static void onPlayerLogout(PlayerScriptData handler) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.LOGOUT, (Event)new PlayerEvent.LogoutEvent(handler.getPlayer()));
    }

    public static void onPlayerMousePressed(EntityPlayerMP player, int button, boolean isDown, boolean isCtrlPressed, boolean isShiftPressed, boolean isAltPressed, boolean isMetaPressed) {
        PlayerScriptData handler = PlayerData.get((EntityPlayer)player).scriptData;
        PlayerEvent.KeyPressedEvent event = new PlayerEvent.KeyPressedEvent(handler.getPlayer(), button, isCtrlPressed, isAltPressed, isShiftPressed, isMetaPressed);
        EventHooks.onEvent((IScriptHandler)handler, isDown ? EnumScriptType.MOUSE_DOWN : EnumScriptType.MOUSE_UP, (Event)event);
    }

    public static void onPlayerOpenGui(EntityPlayerMP player, String newGUI, String oldGUI) {
        if (player == null) {
            return;
        }
        if (newGUI.equals("GuiNPCBankChest") && oldGUI.equals("GuiIngame")) {
            ContainerNPCBank.editPlayerBankData = null;
            Server.sendData(player, EnumPacketClient.SHOW_BANK_PLAYER, "");
        }
        PlayerData data = PlayerData.get((EntityPlayer)player);
        data.hud.currentGUI = newGUI;
        if (!data.scriptData.getEnabled()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)data.scriptData, EnumScriptType.GUI_OPEN, (Event)new PlayerEvent.OpenGUI((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), newGUI, oldGUI));
    }

    public static boolean onPlayerPickUp(PlayerScriptData handler, EntityItem entityItem) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.PICKUP, (Event)new PlayerEvent.PickUpEvent(handler.getPlayer(), Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(entityItem.func_92059_d())));
    }

    public static boolean onPlayerPlace(PlayerScriptData handler, PlayerEvent.PlaceEvent event) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.PLEASED, (Event)event);
    }

    public static void onPlayerPlaySound(PlayerScriptData handler, PlayerEvent.PlayerSound event) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.SOUND_PLAY, (Event)event);
    }

    public static boolean onPlayerRanged(PlayerScriptData handler, PlayerEvent.RangedLaunchedEvent event) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.RANGED_LAUNCHED, (Event)event);
    }

    public static void onPlayerStopSound(PlayerScriptData handler, PlayerEvent.PlayerSound event) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.SOUND_STOP, (Event)event);
    }

    public static PlayerEvent.CustomTeleport onPlayerTeleport(EntityPlayerMP player, BlockPos to, BlockPos portal, int dimId) {
        NpcAPI api = NpcAPI.Instance();
        assert (api != null);
        PlayerEvent.CustomTeleport event = new PlayerEvent.CustomTeleport((IPlayer)api.getIEntity((Entity)player), api.getIPos(portal), api.getIPos(to), dimId);
        if (player == null) {
            return event;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)player).scriptData;
        if (!handler.getEnabled()) {
            return event;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.CUSTOM_TELEPORT, (Event)event);
        return event;
    }

    public static void onPlayerTick(PlayerScriptData handler) {
        if (handler.isClient()) {
            EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.TICK, (Event)new PlayerEvent.UpdateEvent(handler.getPlayer()));
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.TICK, (Event)new PlayerEvent.UpdateEvent(handler.getPlayer()));
    }

    public static void onPlayerTimer(PlayerData data, int id) {
        EventHooks.onEvent((IScriptHandler)data.scriptData, EnumScriptType.TIMER, (Event)new PlayerEvent.TimerEvent(data.scriptData.getPlayer(), id));
    }

    public static boolean onPlayerToss(PlayerScriptData handler, EntityItem entityItem) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.TOSS, (Event)new PlayerEvent.TossEvent(handler.getPlayer(), Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(entityItem.func_92059_d())));
    }

    public static void onPotionInit(PotionScriptData handler) {
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.INIT, (Event)new ForgeEvent.InitEvent());
    }

    public static void onProjectileImpact(EntityProjectile projectile, ProjectileEvent.ImpactEvent event) {
        for (ScriptContainer script : projectile.scripts) {
            if (!script.isValid()) continue;
            script.run(EnumScriptType.PROJECTILE_IMPACT.function, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onProjectileTick(EntityProjectile projectile) {
        ProjectileEvent.UpdateEvent event = new ProjectileEvent.UpdateEvent((IProjectile)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)projectile));
        for (ScriptContainer script : projectile.scripts) {
            if (!script.isValid()) continue;
            script.run(EnumScriptType.PROJECTILE_TICK.function, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static boolean onQuestCanceled(PlayerScriptData handler, Quest quest) {
        if (handler.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.QUEST_CANCELED, (Event)new QuestEvent.QuestCanceledEvent(handler.getPlayer(), quest));
    }

    public static void onQuestFinished(PlayerScriptData handler, Quest quest) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.QUEST_COMPLETED, (Event)new QuestEvent.QuestCompletedEvent(handler.getPlayer(), quest));
    }

    public static boolean onQuestStarted(PlayerScriptData handler, Quest quest) {
        if (handler.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.QUEST_START, (Event)new QuestEvent.QuestStartEvent(handler.getPlayer(), quest));
    }

    public static void onQuestTurnedIn(PlayerScriptData handler, QuestEvent.QuestTurnedInEvent event) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.QUEST_TURNING, (Event)event);
    }

    public static void onGlobalRecipesLoaded(IRecipeHandler handler) {
        HandlerEvent.RecipesLoadedEvent event = new HandlerEvent.RecipesLoadedEvent(handler);
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onScriptBlockBreak(IScriptBlockHandler handler) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.BROKEN, (Event)new BlockEvent.BreakEvent(handler.getBlock()));
    }

    public static void onScriptBlockClicked(IScriptBlockHandler handler, EntityPlayer player) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.CLICKED, (Event)new BlockEvent.ClickedEvent(handler.getBlock(), player));
    }

    public static void onScriptBlockCollide(IScriptBlockHandler handler, Entity entityIn) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.COLLIDE, (Event)new BlockEvent.CollidedEvent(handler.getBlock(), entityIn));
    }

    public static boolean onScriptBlockDoorToggle(IScriptBlockHandler handler) {
        if (handler.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.DOOR_TOGGLE, (Event)new BlockEvent.DoorToggleEvent(handler.getBlock()));
    }

    public static boolean onScriptBlockExploded(IScriptBlockHandler handler) {
        if (handler.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.EXPLODED, (Event)new BlockEvent.ExplodedEvent(handler.getBlock()));
    }

    public static float onScriptBlockFallenUpon(IScriptBlockHandler handler, Entity entity, float distance) {
        if (handler.isClient()) {
            return distance;
        }
        BlockEvent.EntityFallenUponEvent event = new BlockEvent.EntityFallenUponEvent(handler.getBlock(), entity, distance);
        if (EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.FALLEN_UPON, (Event)event)) {
            return 0.0f;
        }
        return event.distanceFallen;
    }

    public static boolean onScriptBlockHarvest(IScriptBlockHandler handler, EntityPlayer player) {
        if (handler.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.HARVESTED, (Event)new BlockEvent.HarvestedEvent(handler.getBlock(), player));
    }

    public static void onScriptBlockInit(IScriptBlockHandler handler) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.INIT, (Event)new BlockEvent.InitEvent(handler.getBlock()));
    }

    public static boolean onScriptBlockInteract(IScriptBlockHandler handler, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (handler.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.INTERACT, (Event)new BlockEvent.InteractEvent(handler.getBlock(), player, side, hitX, hitY, hitZ));
    }

    public static void onScriptBlockNeighborChanged(IScriptBlockHandler handler, BlockPos changedPos) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.NEIGHBOR_CHANGED, (Event)new BlockEvent.NeighborChangedEvent(handler.getBlock(), new BlockPosWrapper(changedPos)));
    }

    public static void onScriptBlockRainFill(IScriptBlockHandler handler) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.RAIN_FILLED, (Event)new BlockEvent.RainFillEvent(handler.getBlock()));
    }

    public static void onScriptBlockRedstonePower(IScriptBlockHandler handler, int prevPower, int power) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.REDSTONE, (Event)new BlockEvent.RedstoneEvent(handler.getBlock(), prevPower, power));
    }

    public static void onScriptBlockTimer(IScriptBlockHandler handler, int id) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.TIMER, (Event)new BlockEvent.TimerEvent(handler.getBlock(), id));
    }

    public static void onScriptBlockUpdate(IScriptBlockHandler handler) {
        if (handler.isClient()) {
            EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.TICK, (Event)new BlockEvent.UpdateEvent(handler.getBlock()));
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.TICK, (Event)new BlockEvent.UpdateEvent(handler.getBlock()));
    }

    public static boolean onScriptItemAttack(ItemScriptedWrapper handler, ItemEvent.AttackEvent event) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.ATTACK, (Event)event);
    }

    public static void onScriptItemInit(ItemScriptedWrapper handler) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.INIT, (Event)new ItemEvent.InitEvent(handler));
    }

    public static boolean onScriptItemInteract(ItemScriptedWrapper handler, ItemEvent.InteractEvent event) {
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.INTERACT, (Event)event);
    }

    public static void onScriptItemPickedUp(ItemScriptedWrapper handler, EntityPlayer player, EntityItem entity) {
        if (handler.isClient()) {
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.PICKEDUP, (Event)new ItemEvent.PickedUpEvent(handler, PlayerData.get((EntityPlayer)player).scriptData.getPlayer(), (IEntityItem)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)entity)));
    }

    public static boolean onScriptItemSpawn(ItemScriptedWrapper handler, EntityItem entity) {
        if (handler.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.SPAWN, (Event)new ItemEvent.SpawnEvent(handler, (IEntityItem)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)entity)));
    }

    public static boolean onScriptItemTossed(ItemScriptedWrapper handler, EntityPlayer player, EntityItem entity) {
        if (handler.isClient()) {
            return false;
        }
        return EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.TOSSED, (Event)new ItemEvent.TossedEvent(handler, PlayerData.get((EntityPlayer)player).scriptData.getPlayer(), (IEntityItem)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)entity)));
    }

    public static void onScriptItemUpdate(ItemScriptedWrapper handler, EntityPlayer player) {
        if (handler.isClient()) {
            EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.TICK, (Event)new ItemEvent.UpdateEvent(handler, PlayerData.get((EntityPlayer)player).scriptData.getPlayer()));
            return;
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.TICK, (Event)new ItemEvent.UpdateEvent(handler, PlayerData.get((EntityPlayer)player).scriptData.getPlayer()));
    }

    public static void onScriptPackage(EntityPlayer player, NBTTagCompound nbt) {
        BaseScriptData handler = Thread.currentThread().getName().toLowerCase().contains("client") ? ScriptController.Instance.clientScripts : PlayerData.get((EntityPlayer)player).scriptData;
        if (!handler.getEnabled()) {
            return;
        }
        if (player == null) {
            player = CustomNpcs.proxy.getPlayer();
        }
        EventHooks.onEvent((IScriptHandler)handler, EnumScriptType.PACKAGE_FROM, (Event)new PlayerEvent.PlayerPackage((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), Objects.requireNonNull(NpcAPI.Instance()).getINbt(nbt)));
    }

    public static void onScriptTriggerEvent(int id, IWorld level, IPos pos, IEntity<?> entity, Object[] arguments) {
        WorldEvent.ScriptTriggerEvent event = new WorldEvent.ScriptTriggerEvent(id, level, pos, entity, arguments);
        if (event.entity != null && event.world != null && !(event.entity.getMCEntity() instanceof FakePlayer)) {
            if (event.entity.getType() == 1) {
                EventHooks.onEvent((IScriptHandler)PlayerData.get((EntityPlayer)((EntityPlayer)event.entity.getMCEntity())).scriptData, EnumScriptType.SCRIPT_TRIGGER, (Event)event);
            } else if (event.entity.getType() == 2) {
                EventHooks.onEvent((IScriptHandler)((EntityNPCInterface)((Object)event.entity.getMCEntity())).script, EnumScriptType.SCRIPT_TRIGGER, (Event)event);
            } else {
                TileEntity tile = event.world.getMCWorld().func_175625_s(event.pos.getMCBlockPos());
                if (tile instanceof IScriptBlockHandler) {
                    EventHooks.onEvent((IScriptHandler)((IScriptBlockHandler)tile), EnumScriptType.SCRIPT_TRIGGER, (Event)event);
                }
            }
        }
        if (ScriptController.Instance.forgeScripts.isClient()) {
            EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.SCRIPT_TRIGGER, (Event)event);
        } else {
            EventHooks.onEvent((IScriptHandler)ScriptController.Instance.forgeScripts, EnumScriptType.SCRIPT_TRIGGER, (Event)event);
        }
    }

    public static void onScriptTriggerEvent(IScriptHandler handler, int id, IWorld world, IPos pos, IEntity<?> entity, Object ... arguments) {
        WorldEvent.ScriptTriggerEvent event = new WorldEvent.ScriptTriggerEvent(id, world, pos, entity, arguments);
        EventHooks.onEvent(handler, EnumScriptType.SCRIPT_TRIGGER, (Event)event);
    }

    public static void onWorldScriptEvent(WorldEvent.ScriptCommandEvent event) {
        EventHooks.onEvent((IScriptHandler)ScriptController.Instance.playerScripts, EnumScriptType.SCRIPT_COMMAND, (Event)event);
    }
}

